/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.large;

import BryceMath.Geometry.Rectangle;
import Data_Structures.Structures.HashingClasses.Set;
import Data_Structures.Structures.List;
import Data_Structures.Structures.UBA;
import Game_Engine.Engine.Objs.Obj;
import Game_Engine.GUI.Components.large.gui_window;
import java.io.PrintStream;
import util.SerialB;

public class gui_list
extends gui_window {
    protected UBA<Obj> data = new UBA();
    private boolean changed;
    protected List<Object> operations = new List();

    public gui_list(double x, double y, int w, int h) {
        super(x, y, w, h);
    }

    public gui_list(Rectangle screen) {
        super(screen);
    }

    public void add(Obj o) {
        o.setX(0.0);
        o.setY(this.getMaxH());
        this.changed = true;
        this.data.add(o);
        this.operations.add(o);
    }

    public void rem() {
        if (this.data.isEmpty()) {
            return;
        }
        Obj o = this.data.rem();
        this.changed = true;
        o.kill();
        this.operations.add("rem()");
    }

    public void clear() {
        while (!this.isEmpty()) {
            this.rem();
        }
    }

    public void deq() {
        if (this.data.isEmpty()) {
            return;
        }
        Obj o = this.data.deq();
        this.changed = true;
        o.kill();
        this.operations.add("deq()");
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public int getIndex(Obj o) {
        return this.data.getIndex(o);
    }

    public Obj getFirst() {
        return this.data.getFirst();
    }

    public Obj getLast() {
        return this.data.getLast();
    }

    @Override
    public void update() {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.changed) {
            super.update();
            return;
        }
        this.changed = true;
        this.updateObjList();
        super.update();
        this.updateDimensions();
    }

    private void updateObjList() {
        int startY = this.world.getView().getViewY();
        Set<Obj> current_contents = this.world.getObjSet();
        this.world.restartObjsList();
        int endY = startY + this.getH();
        int current_y = 0;
        for (Obj o : this.data) {
            o.setY(current_y);
            current_y = (int)o.getY2();
            if (!((double)(startY - o.getH()) <= o.getY()) || !(o.getY() <= (double)endY)) continue;
            this.obj_create(o);
            if (current_contents.includes(o)) continue;
            o.redraw();
        }
    }

    private void updateDimensions() {
        int current_w = this.getMaxW(this.data);
        int size = 2;
        this.world.getView().setWorldDimensions(current_w - size * 2, this.getMaxH() - size * 2);
        int h = this.getH();
        if (this.scrollH != null) {
            h -= this.scrollH.getH();
        }
        if (this.getMaxH() > h) {
            this.scrollV();
        } else {
            this.unscrollV();
        }
        if (current_w > this.getW()) {
            this.scrollH();
        } else {
            this.unscrollH();
        }
    }

    private int getMaxW(Iterable<Obj> L) {
        int w = 0;
        for (Obj o : L) {
            int w_new = o.getW();
            if (w_new <= w) continue;
            w = w_new;
        }
        return w;
    }

    public int getMaxH() {
        if (this.data.isEmpty()) {
            return 0;
        }
        return (int)this.data.getLast().getY2();
    }

    protected void updateData(UBA<Obj> data) {
        this.data = data;
        this.updateObjList();
    }

    @Override
    public void serializeTo(PrintStream stream) {
        for (Object o : this.operations) {
            if (o instanceof String || o instanceof Integer) {
                stream.println(o);
                continue;
            }
            if (!(o instanceof SerialB)) {
                throw new Error("Serialization of " + o.getClass() + " is not currently supported.");
            }
            SerialB s = (SerialB)o;
            stream.println(s.getSerialName());
            s.serializeTo(stream);
        }
    }
}

